/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.compat;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.world.entity.player.Player;
import tschipp.carryon.Constants;

public class GamestageCompat {
    private static Method hasStage;

    public static boolean hasStage(Player player, String stage) {
        if (hasStage == null) {
            return true;
        }
        try {
            return (Boolean)hasStage.invoke(null, player, stage);
        }
        catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
            return true;
        }
    }

    static {
        try {
            Class<?> gamestageHelper = Class.forName("net.darkhax.gamestages.GameStageHelper");
            hasStage = gamestageHelper.getMethod("hasStage", Player.class, String.class);
        }
        catch (Exception e) {
            Constants.LOG.info("Gamestages not found. Disabling.");
        }
    }
}

